// PID_coefficients.v
//
//	Module for computing the three integers iKP, iKI, and iKD
//		for a PID filter from the given real numbers KP,
//		KI, and KD.
//
`timescale 1ps/1fs

module PID_coefficients(
    output reg signed [9:0]  iKP,	// 10-bit signed iKP
    output reg signed [9:0]  iKI,	// 10-bit signed iKI
    output reg signed [13:0] iKD ) ;	// 14-bit signed iKD

    parameter KP = 10.02;
    parameter KI = 0.1329;
    parameter KD = 261.6;

    initial begin
	// iKP is a 10-bit signed integer storing 16 * KP
	iKP = $rtoi( 16 * KP );
	if ( iKP > 1023 )
	    iKP = 1023;
	else if ( iKP < 0 )
	    iKP = 0;

	// iKI is a 10-bit signed integer storing 2048 * KI
	iKI = $rtoi( 2048 * KI );
	if ( iKI > 1023 )
	    iKI = 1023;
	else if ( iKI < 0 )
	    iKI = 0;

	// iKD is a 14-bit signed integer storing 16 * KD
	iKD = $rtoi( 16 * KD );
	if ( iKD > 16383 )
	    iKD = 16383;
	else if ( iKD < 0 )
	    iKD = 0;
    end

endmodule
