// master_clock.v
//
//	Module for creating the master clock signal, running at
//		1 GHz by defaulit.
//
`timescale 1ps/1fs

module master_clock(output reg clk);

    parameter half_period = 500;
    parameter delay = 10;
    integer first;

    initial begin
	// Start the clock output to be logic 0 at t=0
	clk = 0;
	first = 1;
//	$simplis_vpi_probe( clk );
    end

    always begin
	if ( first == 1 ) begin
	    // Change the clock output to be logic 1 at t=delay
	    #(delay) clk = ~clk;
	    first = 0;
	end
	else begin
	    // After t=delay, toggle the clock output once for
	    //   every half period
	    #(half_period) clk=~clk;
	end
    end

endmodule
