// timing_and_counter.v
//
//	Module for generating a digital sawtooth waveform and a few
//		timing signals from the given master_clock signal.
//		The sawtooth waveform can be used to produce a PWM
//		signal.
//
`timescale 1ps/1fs

module timing_and_counter(
    output reg [10:0] count,
    output reg clk_dly,			// Clock signal for unit delay
    output reg clk_a2d,			// Clock signal for A2D
    output reg clk_integ,		// Clock signal for integration
    output reg clk_pid_out,		// Clock signal for outputting the PID
    input master_clock );

    parameter
	delay = 20;

    integer
	i_dummy;

    initial begin
	// Initialize the output so we are close to take an A-to-D sample at
	//   the start of the simulation
	count = 2010;
	clk_dly = 0;
	clk_a2d = 0;
	clk_integ = 0;
	clk_pid_out = 0;
	i_dummy = 0;
    end


    always @( posedge master_clock ) begin
	#(delay) count <= count + 1;
	case ( count )
	    2016: begin
		clk_dly <= #(delay) 1;
	    end
	    2018: begin
		clk_dly <= #(delay) 0;
		clk_a2d <= #(delay) 1;
	    end
	    2020: begin
		clk_a2d <= #(delay) 0;
		clk_integ <= #(delay) 1;
	    end
	    2022: begin
		clk_integ <= #(delay) 0;
		clk_pid_out <= #(delay) 1;
	    end
	    2024: begin
		clk_pid_out <= #(delay) 0;
	    end
	    default: begin
		i_dummy = 0;
	    end
	endcase
    end

endmodule
